function discounts = convert_zero_rates_discounts(term_structure)
% --------------------------------------------------------------------------------------------------
% For each date, convert the zero rate curve into discounts (for middle and end of quarterly time
% intervals)
% --------------------------------------------------------------------------------------------------
% term_structure    ... zero coupon rates with quarterly spacing of maturities
% --------------------------------------------------------------------------------------------------
% sample call: convert_zero_rates_discounts(term_structure)
% --------------------------------------------------------------------------------------------------

dates = term_structure.dates;
r_term = term_structure.zero_rates;

% Calculate discount factors for end and middle of periods
num_dates = length(dates);
T = size(r_term, 2)/4;
horizon = repmat(0.25:0.25:T, num_dates, 1);
discounts = 1 ./ (1 + r_term).^horizon;
r_term2 = (r_term + [r_term(:,1) r_term(:,1:end-1)])/2;
horizon_inbetween = (horizon - 1/8);
discounts_inbetween = 1 ./ (1 + r_term2).^horizon_inbetween;

% Put discounts into structure
discounts = struct('discounts', {discounts}, 'discounts_inbetween', {discounts_inbetween}, ...
                   'horizon', {(0.25:0.25:T)'}, 'horizon_inbetween', {(0.25:0.25:T)'-1/8}, 'dates', {dates});
